/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.capability.object;

import dev.toma.gunsrpg.api.common.data.IAimInfo;
import dev.toma.gunsrpg.api.common.data.IHandState;
import dev.toma.gunsrpg.api.common.data.IPlayerCapEntry;
import lib.toma.animations.AnimationUtils;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;

public class AimInfo
implements IAimInfo,
IPlayerCapEntry {
    private final IHandState handState;
    private IPlayerCapEntry.IClientSynchReq request = () -> {};
    private int slot;
    private boolean aiming;
    private float progress;
    private float progressOld;

    public AimInfo(IHandState state) {
        this.handState = state;
    }

    @Override
    public void tick(PlayerEntity player) {
        boolean server = !player.field_70170_p.field_72995_K;
        int slotIn = player.field_71071_by.field_70461_c;
        if (server && this.aiming && (slotIn != this.slot || player.func_184614_ca().func_190926_b() || player.func_70051_ag() || this.handState.areHandsBusy())) {
            this.setAiming(false, player);
            this.request.makeSyncRequest();
        }
        float aimingSpeed = 0.175f;
        this.progressOld = this.progress;
        if (this.aiming && this.progress < 1.0f) {
            this.progress = Math.min(1.0f, this.progress + aimingSpeed);
        } else if (!this.aiming && this.progress > 0.0f) {
            this.progress = Math.max(0.0f, this.progress - aimingSpeed);
        }
    }

    @Override
    public int getFlag() {
        return 1;
    }

    @Override
    public boolean isAiming() {
        return this.progress == 1.0f;
    }

    @Override
    public boolean startedAiming() {
        return this.aiming;
    }

    @Override
    public void setAiming(boolean aiming, PlayerEntity player) {
        if (aiming) {
            this.slot = player.field_71071_by.field_70461_c;
        }
        this.aiming = aiming;
    }

    @Override
    public float getProgress() {
        return this.progress;
    }

    @Override
    public float getProgress(float deltaTime) {
        return AnimationUtils.linearInterpolate(this.progress, this.progressOld, deltaTime);
    }

    @Override
    public void toNbt(CompoundNBT nbt) {
        CompoundNBT cnbt = new CompoundNBT();
        cnbt.func_74768_a("slot", this.slot);
        cnbt.func_74757_a("aim", this.aiming);
        cnbt.func_74776_a("progress", this.progress);
        nbt.func_218657_a("aimInfo", (INBT)cnbt);
    }

    @Override
    public void fromNbt(CompoundNBT nbt) {
        CompoundNBT cnbt = nbt.func_150297_b("aimInfo", 10) ? nbt.func_74775_l("aimInfo") : new CompoundNBT();
        this.slot = cnbt.func_74762_e("slot");
        this.aiming = cnbt.func_74767_n("aim");
        this.progress = cnbt.func_74760_g("progress");
    }

    @Override
    public void setClientSynch(IPlayerCapEntry.IClientSynchReq request) {
        this.request = request;
    }
}

